/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.info;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.text.DecimalFormat;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.time.DurationFormatUtils;
import pregenerator.base.api.IRenderHelper;
import pregenerator.client.info.DeletionProcessorInfo;
import pregenerator.client.info.PregenProcessorInfo;

public interface IProcessorInfo {
    public static final DecimalFormat FORMAT = new DecimalFormat("###,###");
    public static final Int2ObjectMap<Supplier<IProcessorInfo>> GENERATORS = new Int2ObjectLinkedOpenHashMap();

    public static void init() {
        IProcessorInfo.register(1, PregenProcessorInfo::new);
        IProcessorInfo.register(2, DeletionProcessorInfo::new);
    }

    public static void register(int id, Supplier<IProcessorInfo> provider) {
        GENERATORS.put(id, provider);
    }

    public static IProcessorInfo create(int id) {
        Supplier info = (Supplier)GENERATORS.get(id);
        return info == null ? null : (IProcessorInfo)info.get();
    }

    public void read(FriendlyByteBuf var1);

    @OnlyIn(value=Dist.CLIENT)
    public void render(IRenderHelper var1, int var2, int var3);

    default public int getWidth() {
        return 0;
    }

    default public int getHeight() {
        return 0;
    }

    public int getID();

    default public String getTime(long time) {
        return DurationFormatUtils.formatDuration((long)Math.abs(time), (String)"HH:mm:ss");
    }

    public static long toMB(long base) {
        return base >> 20;
    }
}

